% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_cf1.R
\docType{class}
\name{cf1-class}
\alias{cf1-class}
\title{Class of canonical form 1 (PH distribution)}
\description{
Parameters for a canonical form 1 which is a subclass of PH.
This is extended from \code{\linkS4class{ph}}.
}
\section{Slots}{

\describe{
\item{\code{rate}}{Transition rates to the next phase.}

\item{\code{size}}{The number of phases (transient states).}

\item{\code{alpha}}{A probability (row) vector to decide an initial phase.}

\item{\code{Q}}{A square matrix that means transition rates between phases.}

\item{\code{xi}}{A column vector for exiting rates from phases to an absorbing state.}

\item{\code{df}}{The number of free parameters.}
}}

\note{
Objects are usually created by a \link{cf1}.

Methods:
\describe{
\item{\code{\link{ph.moment}}}{\code{signature(ph = "cf1")}: ... }
\item{emfit.init}{\code{signature(model = "cf1")}: ... }
\item{emfit.mstep}{\code{signature(model = "cf1")}: ... }
}
}
\examples{
## create a CF1 with 5 phases
(param1 <- cf1(5))

## create a CF1 with 5 phases
(param1 <- cf1(size=5))

## create a CF1 with specific parameters
(param2 <- cf1(alpha=c(1,0,0), rate=c(1.0,2.0,3.0)))

## p.d.f. for 0, 0.1, ..., 1
(dph(x=seq(0, 1, 0.1), ph=param2))

## c.d.f. for 0, 0.1, ..., 1
(pph(q=seq(0, 1, 0.1), ph=param2))

## generate 10 samples (this is quiker than rph with general ph)
(rph(n=10, ph=param2))

}
\seealso{
Classes \code{\linkS4class{ph}} and \code{\linkS4class{herlang}}.
}
\keyword{classes}
