% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_geojson.R
\name{add_geojson}
\alias{add_geojson}
\title{Add Geojson}
\usage{
add_geojson(map, data = get_map_data(map), layer_id = NULL,
  stroke_colour = NULL, stroke_opacity = NULL, stroke_width = NULL,
  fill_colour = NULL, fill_opacity = NULL, radius = NULL,
  elevation = NULL, light_settings = list(), legend = F,
  legend_options = NULL, legend_format = NULL,
  auto_highlight = FALSE, tooltip = NULL,
  highlight_colour = "#AAFFFFFF", palette = "viridis",
  na_colour = "#808080FF", update_view = TRUE, focus_layer = FALSE,
  transitions = NULL)
}
\arguments{
\item{map}{a mapdeck map object}

\item{data}{data to be used in the layer. Can be a url to GeoJSON}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type. Layers with the same id are likely
to conflict and not plot correctly}

\item{stroke_colour}{column of an \code{sf} object, or field inside a GeoJSON \code{property} to use for colour}

\item{stroke_opacity}{column of an \code{sf} object, or field inside a GeoJSON \code{property} to use for opacity}

\item{stroke_width}{column of an \code{sf} object, or field inside a GeoJSON \code{property} to use for width}

\item{fill_colour}{column of an \code{sf} object, or field inside a GeoJSON \code{property} to use for colour}

\item{fill_opacity}{column of an \code{sf} object, or field inside a GeoJSON \code{property} to use for opacity}

\item{radius}{radius of points in meters. See details}

\item{elevation}{elevation of polygons. See details}

\item{light_settings}{list of light setting parameters. See \link{light_settings}}

\item{legend}{either a logical indiciating if the legend(s) should be displayed, or
a named list indicating which colour attributes should be included in the legend.}

\item{legend_options}{A list of options for controlling the legend.}

\item{legend_format}{A list containing functions to apply to legend values. See section legend}

\item{auto_highlight}{logical indicating if the shape under the mouse should auto-highlight}

\item{tooltip}{variable of \code{data} containing text or HTML to render as a tooltip.
Only works on \code{sf} objects.}

\item{highlight_colour}{hex string colour to use for highlighting. Must contain the alpha component.}

\item{palette}{string or matrix. String will be one of \code{colourvalues::colour_palettes()}.
A matrix is a 3 or 4 column numeric matrix of values between [0, 255],
where the 4th column represents the alpha.}

\item{na_colour}{hex string colour to use for NA values}

\item{update_view}{logical indicating if the map should update the bounds to include this layer}

\item{focus_layer}{logical indicating if the map should update the bounds to only include this layer}

\item{transitions}{list specifying the duration of transitions.}
}
\description{
The GeoJson Layer takes in GeoJson formatted data and renders it as interactive polygons,
lines and points
}
\section{transitions}{


The transitions argument lets you specify the time it will take for the shapes to transition
from one state to the next. Only works in an interactive environment (Shiny)
and on WebGL-2 supported browsers and hardware.

The time is in milliseconds

Available transitions for geojson

list(
fill_colour = 0,
stroke_colour = 0,
stroke_width = 0,
elevation = 0,
radius = 0
)
}

\section{Raw Geojson}{


If using a GeoJSON string, and you \strong{do not} suppply one of the colouring arguments, the
function will look for these fields inside the \code{properties} field of the Geojson

\strong{fill_colour}
\itemize{
  \item{fill_colour}
  \item{fillColour}
  \item{fill_color}
  \item{fillColor}
  \item{fill}
}

\strong{stroke_colour}
\itemize{
  \item{stroke_colour}
  \item{strokeColour}
  \item{stroke_color}
  \item{strokeColor}
  \item{stroke}
  \item{line_colour}
  \item{lineColour}
  \item{line_color}
  \item{lineColor}
  \item{line}
}

\strong{stroke_width}
\itemize{
  \item{stroke_width}
  \item{strokeWdith}
  \item{line_width}
  \item{lineWidth}
  \item{width}
}

\itemize{
  \item{elevation}
  \item{radius}
}

These colour values should be valid hex-colour strings.

If you \strong{do} provide values for the colouring arguments, the function will assume
you want to use specific fields in the geojson for colouring. However, if you only supply a
\code{fill_colour} value, the function will not automatically detect the \code{stroke_colour}
(and vice versa)
}

\section{data}{


If the \code{data} is a simple feature object, the geometry column is automatically
detected. If the sf object contains more than one geometry column and you want to use a specific one,
you'll need to set the active geometry using \code{sf::st_geometry( x ) <- "your_column" },
where \code{"your_column"} is the name of the column you're activating. See \code{?sf::st_geometry}
}

\section{legend}{


The \code{legend_options} can be used to control the appearance of the legend.
This should be a named list, where the names are one of
\itemize{
  \item{css - a string of valid \code{css} for controlling the appearance of the legend}
  \item{title - a string to use for the title of the legend}
}

If the layer allows different fill and stroke colours, you can use different options for each. See examples in \link{add_arc}.

The \code{legend_format} can be used to control the format of the values in the legend.
This should be a named list, where the names are one of
\itemize{
  \item{fill_colour}
  \item{stroke_colour}
}

depending on which type of colouring the layer supports.

The list elements must be functions to apply to the values in the legend.
}

\examples{
\donttest{

## You need a valid access token from Mapbox
key <- 'abc'

## Not supplying colouring arguments, the function will try and find them in the GeoJSON
mapdeck(
 token = key
 , location = c(145, -37.9)
 , zoom = 8
 , style = mapdeck_style("dark")
 , pitch = 35
) \%>\%
 add_geojson(
   data = geojson
   , auto_highlight = TRUE
 )

## only supplying values to use for fill, the stroke will be default
mapdeck(
 token = key
 , location = c(145, -37.9)
 , zoom = 8
 , style = mapdeck_style("dark")
 , pitch = 35
) \%>\%
 add_geojson(
   data = geojson
   , fill_colour = "random"
 )

mapdeck(
 token = key
 , location = c(145, -37.9)
 , zoom = 8
 , style = mapdeck_style("dark")
 , pitch = 35
) \%>\%
 add_geojson(
   data = geojson
   , fill_colour = "random"
   , stroke_colour = "random"
 )

mapdeck(
 token = key
 , location = c(145, -37.9)
 , zoom = 8
 , style = mapdeck_style("dark")
 , pitch = 35
) \%>\%
 add_geojson(
   data = geojson
   , fill_colour = "random"
   , stroke_colour = "random"
   , elevation = 300
 )

## putting elevation and width values onto raw GeoJSON
library(geojsonsf)
sf <- geojsonsf::geojson_sf( geojson )
sf$width <- sample(1:100, size = nrow(sf), replace = TRUE)
sf$elevation <- sample(100:1000, size = nrow(sf), replace = T)
geo <- geojsonsf::sf_geojson( sf )

mapdeck(
 token = key
 , location = c(145, -37.9)
 , zoom = 8
 , style = mapdeck_style("dark")
 , pitch = 35
) \%>\%
 add_geojson(
   data = geo
 )

}


}
