% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_move_can.R
\name{esp_move_can}
\alias{esp_move_can}
\title{Displace a \code{\link[sf:sf]{sf}} object located in the Canary Islands}
\usage{
esp_move_can(x, moveCAN = TRUE)
}
\arguments{
\item{x}{An \code{\link[sf:sf]{sf}} object. It may be \code{sf} or \code{sfc} object.}

\item{moveCAN}{A logical \code{TRUE/FALSE} or a vector of coordinates
\code{c(lat, lon)}.}
}
\value{
A \code{\link[sf:sf]{sf}} object of the same class and same CRS than \code{x}
but displaced accordingly.
}
\description{
Helper function to displace an external \code{\link[sf:sf]{sf}} object (potentially
representing a location in the Canary Islands) to align it with the objects
provided by \code{\link[sf:sf]{sf}} with the option \code{moveCAN = TRUE}.
}
\details{
This is a helper function that intends to ease the representation of objects
located in the Canary Islands that have been obtained from other sources
rather than the package \CRANpkg{mapSpain}.
}
\examples{
library(sf)
teide <- data.frame(
  name = "Teide Peak",
  lon = -16.6437593,
  lat = 28.2722883
)

teide_sf <- st_as_sf(teide, coords = c("lon", "lat"), crs = 4326)

# If we use any mapSpain produced object with moveCAN = TRUE...

esp <- esp_get_country(moveCAN = c(13, 0))

library(ggplot2)


ggplot(esp) +
  geom_sf() +
  geom_sf(data = teide_sf, color = "red") +
  labs(
    title = "Canary Islands displaced",
    subtitle = "But not the external Teide object"
  )



# But we can

teide_sf_disp <- esp_move_can(teide_sf, moveCAN = c(13, 0))

ggplot(esp) +
  geom_sf() +
  geom_sf(data = teide_sf_disp, color = "red") +
  labs(
    title = "Canary Islands displaced",
    subtitle = "And also the external Teide object"
  )

}
\seealso{
Other helper: 
\code{\link{esp_check_access}()}

Other Canary Islands: 
\code{\link{esp_get_can_box}()}
}
\concept{Canary Islands}
\concept{helper}
