% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_hypsobath.R
\name{esp_get_hypsobath}
\alias{esp_get_hypsobath}
\title{Get hypsometry and bathymetry of Spain}
\source{
IGN data via a custom CDN (see
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata}.
}
\usage{
esp_get_hypsobath(
  epsg = "4258",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = "3",
  spatialtype = "area"
)
}
\arguments{
\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item "4258": ETRS89
\item "4326": WGS84
\item "3035": ETRS89 / ETRS-LAEA
\item "3857": Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
\code{.geojson} file.}

\item{cache_dir}{A path to a cache directory. The directory can also be
set globally with \code{options(mapSpain_cache_dir = "path/to/dir")}.
See Details on \code{\link[=esp_get_nuts]{esp_get_nuts()}}.}

\item{verbose}{Display information. Useful for debugging,
default is \code{FALSE}.}

\item{resolution}{Resolution of the shape. Values available are "3" or "6.5".}

\item{spatialtype}{Spatial type of the output. Use "area" for \code{POLYGONS} or
"line" for \code{LINESTRING}.}
}
\value{
A \code{POLYGON} or \code{LINESTRING} object.
}
\description{
Loads a simple feature (\code{sf}) object containing lines or areas with the
hypsometry and bathymetry of Spain.
}
\details{
Metadata available on
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata/}.
}
\examples{

\donttest{
# This code would produce a nice plot - It will take a few seconds to run
library(sf)
library(cartography)

hypsobath <- esp_get_hypsobath()

# Tints from Wikipedia
# https://en.wikipedia.org/wiki/Wikipedia:WikiProject_Maps/Conventions

bath_tints <- colorRampPalette(
  rev(
    c(
      "#D8F2FE", "#C6ECFF", "#B9E3FF",
      "#ACDBFB", "#A1D2F7", "#96C9F0",
      "#8DC1EA", "#84B9E3", "#79B2DE",
      "#71ABD8"
    )
  )
)

hyps_tints <- colorRampPalette(
  rev(
    c(
      "#F5F4F2", "#E0DED8", "#CAC3B8", "#BAAE9A",
      "#AC9A7C", "#AA8753", "#B9985A", "#C3A76B",
      "#CAB982", "#D3CA9D", "#DED6A3", "#E8E1B6",
      "#EFEBC0", "#E1E4B5", "#D1D7AB", "#BDCC96",
      "#A8C68F", "#94BF8B", "#ACD0A5"
    )
  )
)


# Create palette
br_bath <- seq(-6250, -250, 250)
br_terrain <- seq(0, 3100, 100)


finalbreaks <- sort(unique(c(br_bath, br_terrain)))
pal <- c(bath_tints(length(br_bath)), hyps_tints(length(br_terrain)))

opar <- par(no.readonly = TRUE)


# Plot Canarias
opar <- par(no.readonly = TRUE)
par(mar = c(0, 0, 0, 0))
plot_sf(hypsobath,
  xlim = c(-18.6, -13.5),
  ylim = c(27.6, 29.5)
)
choroLayer(
  hypsobath,
  var = "val_inf",
  breaks = finalbreaks,
  col = pal,
  legend.pos = "n",
  border = NA,
  add = TRUE
)

# Plot Mainland
opar <- par(no.readonly = TRUE)
par(mar = c(0, 0, 0, 0))
plot_sf(hypsobath,
  xlim = c(-9, 4.4),
  ylim = c(35.8, 44)
)
choroLayer(
  hypsobath,
  var = "val_inf",
  breaks = finalbreaks,
  col = pal,
  legend.pos = "n",
  border = NA,
  add = TRUE
)

par(opar)
}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
\concept{natural}
