% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_correlation.R
\name{manip_permutation}
\alias{manip_permutation}
\alias{to_permuted}
\title{Network permutation}
\usage{
to_permuted(.data, with_attr = TRUE)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{with_attr}{Logical whether any attributes of the object
should be retained.
By default TRUE.}
}
\description{
\code{to_permuted()} permutes the network using a Fisher-Yates shuffle
on both the rows and columns (for a one-mode network)
or on each of the rows and columns (for a two-mode network).
}
\examples{
graphr(ison_adolescents, node_size = 4)
graphr(to_permuted(ison_adolescents), node_size = 4)
}
\seealso{
Other modifications: 
\code{\link{manip_as}},
\code{\link{manip_correlation}},
\code{\link{manip_deformat}},
\code{\link{manip_from}},
\code{\link{manip_levels}},
\code{\link{manip_miss}},
\code{\link{manip_nodes}},
\code{\link{manip_paths}},
\code{\link{manip_preformat}},
\code{\link{manip_project}},
\code{\link{manip_reformat}},
\code{\link{manip_scope}},
\code{\link{manip_split}},
\code{\link{manip_ties}}
}
\concept{modifications}
