% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/member_equivalence.R
\name{member_equivalence}
\alias{member_equivalence}
\alias{node_in_equivalence}
\alias{node_in_structural}
\alias{node_in_regular}
\alias{node_in_automorphic}
\title{Equivalence clustering algorithms}
\source{
\url{https://github.com/aslez/concoR}
}
\usage{
node_in_equivalence(
  .data,
  census,
  k = c("silhouette", "elbow", "strict"),
  cluster = c("hierarchical", "concor"),
  distance = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski"),
  range = 8L
)

node_in_structural(
  .data,
  k = c("silhouette", "elbow", "strict"),
  cluster = c("hierarchical", "concor"),
  distance = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski"),
  range = 8L
)

node_in_regular(
  .data,
  k = c("silhouette", "elbow", "strict"),
  cluster = c("hierarchical", "concor"),
  distance = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski"),
  range = 8L
)

node_in_automorphic(
  .data,
  k = c("silhouette", "elbow", "strict"),
  cluster = c("hierarchical", "concor"),
  distance = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski"),
  range = 8L
)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{census}{A matrix returned by a \verb{node_by_*()} function.}

\item{k}{Typically a character string indicating which method
should be used to select the number of clusters to return.
By default \code{"silhouette"}, other options include \code{"elbow"} and \code{"strict"}.
\code{"strict"} returns classes with members only when strictly equivalent.
\code{"silhouette"} and \code{"elbow"} select classes based on the distance between
clusters or between nodes within a cluster.
Fewer, identifiable letters, e.g. \code{"e"} for elbow, is sufficient.
Alternatively, if \code{k} is passed an integer, e.g. \code{k = 3},
then all selection routines are skipped in favour of this number of clusters.}

\item{cluster}{Character string indicating whether clusters should be
clustered hierarchically (\code{"hierarchical"}) or
through convergence of correlations (\code{"concor"}).
Fewer, identifiable letters, e.g. \code{"c"} for CONCOR, is sufficient.}

\item{distance}{Character string indicating which distance metric
to pass on to \code{stats::dist}.
By default \code{"euclidean"}, but other options include
\code{"maximum"}, \code{"manhattan"}, \code{"canberra"}, \code{"binary"}, and \code{"minkowski"}.
Fewer, identifiable letters, e.g. \code{"e"} for Euclidean, is sufficient.}

\item{range}{Integer indicating the maximum number of (k) clusters
to evaluate.
Ignored when \code{k = "strict"} or a discrete number is given for \code{k}.}
}
\description{
These functions combine an appropriate \verb{node_by_*()} function
together with methods for calculating the hierarchical clusters
provided by a certain distance calculation.
\itemize{
\item \code{node_in_equivalence()} assigns nodes membership based on their equivalence
with respective to some census/class.
The following functions call this function, together with an appropriate census.
\itemize{
\item \code{node_in_structural()} assigns nodes membership based on their
having equivalent ties to the same other nodes.
\item \code{node_in_regular()} assigns nodes membership based on their
having equivalent patterns of ties.
\item \code{node_in_automorphic()} assigns nodes membership based on their
having equivalent distances to other nodes.
}
}

A \code{plot()} method exists for investigating the dendrogram
of the hierarchical cluster and showing the returned cluster
assignment.
}
\examples{
\donttest{
(nse <- node_in_structural(ison_algebra))
plot(nse)
}
\donttest{
(nre <- node_in_regular(ison_southern_women,
  cluster = "concor"))
plot(nre)
}
\donttest{
(nae <- node_in_automorphic(ison_southern_women,
  k = "elbow"))
plot(nae)
}
}
\seealso{
Other memberships: 
\code{\link{mark_core}},
\code{\link{member_cliques}},
\code{\link{member_community_hier}},
\code{\link{member_community_non}},
\code{\link{member_components}}
}
\concept{memberships}
