% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.paths.R
\name{print.all_paths}
\alias{print.all_paths}
\title{Print 'all_paths' Class Object}
\usage{
\method{print}{all_paths}(x, ...)
}
\arguments{
\item{x}{A 'all_paths'-class object.}

\item{...}{Optional arguments.}
}
\value{
\code{x} is returned invisibly. Called for its side effect.
}
\description{
Print the content of 'all_paths'-class object,
which can be generated by \code{\link[=all_indirect_paths]{all_indirect_paths()}}.
}
\details{
This function is used to
print the paths identified in a readable
format.
}
\examples{
library(lavaan)
data(data_serial_parallel)
mod <-
"
m11 ~ x + c1 + c2
m12 ~ m11 + x + c1 + c2
m2 ~ x + c1 + c2
y ~ m12 + m2 + m11 + x + c1 + c2
"
fit <- sem(mod, data_serial_parallel,
           fixed.x = FALSE)
# All indirect paths
out1 <- all_indirect_paths(fit)
out1

}
\seealso{
\code{\link[=all_indirect_paths]{all_indirect_paths()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
