% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_lm_list.R
\name{print.lm_list}
\alias{print.lm_list}
\title{Print an \code{lm_list}-Class
Object}
\usage{
\method{print}{lm_list}(x, ...)
}
\arguments{
\item{x}{The output of \code{\link[=lm2list]{lm2list()}}.}

\item{...}{Other arguments. Not
used.}
}
\value{
\code{x} is returned invisibly.
Called for its side effect.
}
\description{
Print the content of the
output of \code{\link[=lm2list]{lm2list()}}.
}
\examples{

data(data_serial_parallel)
lm_m11 <- lm(m11 ~ x + c1 + c2, data_serial_parallel)
lm_m12 <- lm(m12 ~ m11 + x + c1 + c2, data_serial_parallel)
lm_m2 <- lm(m2 ~ x + c1 + c2, data_serial_parallel)
lm_y <- lm(y ~ m11 + m12 + m2 + x + c1 + c2, data_serial_parallel)
# Join them to form a lm_list-class object
lm_serial_parallel <- lm2list(lm_m11, lm_m12, lm_m2, lm_y)
lm_serial_parallel

}
