% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_cond_indirect_effects.R
\name{confint.cond_indirect_effects}
\alias{confint.cond_indirect_effects}
\title{Confidence Intervals of
Indirect Effects or Conditional
Indirect Effects}
\usage{
\method{confint}{cond_indirect_effects}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{The output of
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}.}

\item{parm}{Ignored. Always returns
the confidence intervals of
the effects for all levels stored.}

\item{level}{The level of confidence,
default is .95, returning the 95\%
confidence interval. Ignored for now
and will use the level of the stored
intervals.}

\item{...}{Additional arguments.
Ignored by the function.}
}
\value{
A data frame with two
columns, one for each confidence
limit of the confidence intervals.
The number of rows is equal to the
number of rows of \code{object}.
}
\description{
Return the confidence
intervals of the conditional indirect
effects or conditional effects in the
output of \code{\link[=cond_indirect_effects]{cond_indirect_effects()}}.
}
\details{
It extracts and returns the
columns for confidence intervals, if
available.

The type of confidence intervals
depends on the call used to
compute the effects. If confidence
intervals have already been formed
(e.g., by bootstrapping or Monte
Carlo), then this function
merely retrieves the confidence
intervals stored.

If the following conditions are met, the
stored standard errors, if available,
will be used test an effect and
form it confidence interval:
\itemize{
\item Confidence intervals have not been
formed (e.g., by bootstrapping or
Monte Carlo).
\item The path has no mediators.
\item The model has only one group.
\item The path is moderated by one or
more moderator.
\item Both the \code{x}-variable and the
\code{y}-variable are not standardized.
}

If the model is fitted by OLS
regression (e.g., using \code{\link[stats:lm]{stats::lm()}}),
then the variance-covariance matrix
of the coefficient estimates will be
used, and confidence
intervals are computed from the \emph{t}
statistic.

If the model is fitted by structural
equation modeling using \code{lavaan}, then
the variance-covariance computed by
\code{lavaan} will be used,
and confidence intervals are computed
from the \emph{z} statistic.
\subsection{Caution}{

If the model is fitted by structural
equation modeling and has moderators,
the standard errors, \emph{p}-values,
and confidence interval computed
from the variance-covariance matrices
for conditional effects
can only be trusted if all covariances
involving the product terms are free.
If any of them are fixed, for example,
fixed to zero, it is possible
that the model is not invariant to
linear transformation of the variables.
}
}
\examples{

library(lavaan)
dat <- modmed_x1m3w4y1
mod <-
"
m1 ~ x  + w1 + x:w1
m2 ~ m1
y  ~ m2 + x + w4 + m2:w4
"
fit <- sem(mod, dat, meanstructure = TRUE, fixed.x = FALSE, se = "none", baseline = FALSE)
est <- parameterEstimates(fit)

# Examples for cond_indirect():

# Create levels of w1 and w4
w1levels <- mod_levels("w1", fit = fit)
w1levels
w4levels <- mod_levels("w4", fit = fit)
w4levels
w1w4levels <- merge_mod_levels(w1levels, w4levels)

# Conditional effects from x to m1 when w1 is equal to each of the levels
# R should be at least 2000 or 5000 in real research.
out1 <- suppressWarnings(cond_indirect_effects(x = "x", y = "m1",
                      wlevels = w1levels, fit = fit,
                      boot_ci = TRUE, R = 20, seed = 54151,
                      parallel = FALSE,
                      progress = FALSE))
confint(out1)


}
\seealso{
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}
}
