% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_cond_indirect_effect.R
\name{print.cond_indirect_effects}
\alias{print.cond_indirect_effects}
\title{Print a
'cond_indirect_effects' Class Object}
\usage{
\method{print}{cond_indirect_effects}(x, digits = 3, annotation = TRUE, ...)
}
\arguments{
\item{x}{The output of
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}.}

\item{digits}{Number of digits to
display. Default is 3.}

\item{annotation}{Logical. Whether
the annotation after the table of
effects is to be printed. Default is
\code{TRUE.}}

\item{...}{Other arguments. Not
used.}
}
\value{
\code{x} is returned invisibly.
Called for its side effect.
}
\description{
Print the content of the
output of \code{\link[=cond_indirect_effects]{cond_indirect_effects()}}
}
\examples{

library(lavaan)
dat <- modmed_x1m3w4y1
mod <-
"
m1 ~ a1 * x  + d1 * w1 + e1 * x:w1
m2 ~ a2 * x
y  ~ b1 * m1 + b2 * m2 + cp * x
"
fit <- sem(mod, dat,
           meanstructure = TRUE, fixed.x = FALSE, se = "none", baseline = FALSE)

# Conditional effects from x to m1 when w1 is equal to each of the default levels
cond_indirect_effects(x = "x", y = "m1",
                      wlevels = "w1", fit = fit)

# Conditional Indirect effect from x1 through m1 to y,
# when w1 is equal to each of the default levels
out <- cond_indirect_effects(x = "x", y = "y", m = "m1",
                      wlevels = "w1", fit = fit)
out

print(out, digits = 5)

print(out, annotation = FALSE)


}
\seealso{
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}
}
