% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{ptest}
\alias{ptest}
\title{Prediction Model Function}
\usage{
ptest(
  object,
  Z = Z,
  newdata = NULL,
  testZ = NULL,
  regmethod = "glm",
  methods1 = c("boot", "boot632", "cv", "repeatedcv", "LOOCV", "LGOCV")[4],
  metric = "ROC",
  number1 = 10,
  repeats1 = 5,
  params = NULL
)
}
\arguments{
\item{object}{a matrix indicating the explanatory variable(s), or an object of class \code{msma}, which is a result of a call to \code{msma} .}

\item{Z}{a vector, response variable(s) for the construction of the prediction model. The length of Z is the number of subjects for the training.}

\item{newdata}{a matrix for the prediction.}

\item{testZ}{a vector, response variable(s) for the prediction evaluation. The length of testZ is the number of subjects for the validation.}

\item{regmethod}{a character for the name of the prediction model. This corresponds to the \code{method} argument of the \code{train} function in the \code{caret} package.}

\item{methods1}{a character for the name of the evaluation method.}

\item{metric}{a character for the name of summary metric to select the optimal model.}

\item{number1}{a number of folds or number of resampling iterations}

\item{repeats1}{a number of repeats for the repeated cross-validation}

\item{params}{a data frame with possible tuning values.}
}
\value{
\item{object}{{an object of class "\code{msma}", usually, a result of a call to \code{msma}}}

\item{trainout}{a predictive model output from the train function in the caret package with scores computed by the msma function as predictors}

\item{scorecvroc}{the training evaluation measure and values of the tuning parameters}

\item{evalmeasure}{evaluation measures and information criterion for the msma model}

\item{traincnfmat}{a confusion matrix in training data}

\item{predcnfmat}{a confusion matrix in test data}
}
\description{
This is the function that creates and evaluates the predictive model.
}
\details{
\code{ptest} requires the output result of \code{msma} function.
}
\examples{

\donttest{
data(baseimg)
data(diffimg)
data(mask)
data(template)
img1 = simbrain(baseimg = baseimg, diffimg = diffimg, mask=mask)
B1 = rbfunc(imagedim=img1$imagedim, seppix=2, hispec=FALSE, mask=img1$brainpos)
SB1 = basisprod(img1$S, B1)
fit111 = msma(SB1, comp=2)
predmodel = ptest(fit111, Z=img1$Z)
}

}
