% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{basisprod}
\alias{basisprod}
\title{Product Radial Basis Function}
\usage{
basisprod(A, B)
}
\arguments{
\item{A}{a list or a matrix correponding to the output for the \code{rbfunc} function with the argument hispec=FALSE or data matrix, respectivey.}

\item{B}{a list or a matrix.}
}
\description{
This is a function to product the output for the rbfunc function with data matrix for a dimension reduction.
}
\details{
\code{basisprod} requires one list and one matrix.
}
\examples{

imagedim1=c(10,10,10)

B1 = rbfunc(imagedim=imagedim1, seppix=4, hispec=TRUE)
B2 = rbfunc(imagedim=imagedim1, seppix=4, hispec=FALSE)

n = 50
S = matrix(rnorm(n*prod(imagedim1)), nrow = n, ncol = prod(imagedim1))

SB1 = S \%*\% B1
SB12 = tcrossprod(S, t(B1))
all(SB1-SB12 == 0)

SB2 = basisprod(S, B2)
all(SB1-SB2 == 0)

BS1 = t(B1) \%*\% t(S)
BS2 = basisprod(B2, S)
all(BS1-t(BS2) == 0)

}
