/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;

public class Csv2FeatureVector
extends Pipe {
    private static Logger logger = MalletLogger.getLogger(Csv2FeatureVector.class.getName());

    public Csv2FeatureVector(int capacity) {
        this.dataAlphabet = new Alphabet(capacity);
    }

    public Csv2FeatureVector() {
        this(1000);
    }

    @Override
    public Instance pipe(Instance carrier) {
        CharSequence c = (CharSequence)carrier.getData();
        String[] pairs = ((Object)c).toString().trim().split("\\s+");
        int[] keys = new int[pairs.length];
        double[] values = new double[pairs.length];
        for (int i = 0; i < pairs.length; ++i) {
            int delimIndex = pairs[i].lastIndexOf(":");
            if (delimIndex <= 0 || delimIndex == pairs[i].length() - 1) {
                keys[i] = this.dataAlphabet.lookupIndex(pairs[i], true);
                values[i] = 1.0;
                continue;
            }
            keys[i] = this.dataAlphabet.lookupIndex(pairs[i].substring(0, delimIndex), true);
            values[i] = Double.parseDouble(pairs[i].substring(delimIndex + 1));
        }
        FeatureVector fv = new FeatureVector(this.dataAlphabet, keys, values);
        carrier.setData(fv);
        return carrier;
    }
}

