# WARNING - Generated by {fusen} from dev/flat_utils.Rmd: do not edit by hand

#' Check if the list provided is correctly a list of processed_spectra objects paths
#'
#'
#' @return A logical TRUE if the list contains objects created by [process_spectra]. FALSE otherwise.
#'
#' @noRd
#' @examples
#' foo <- list(
#'   "spectra" = list(MALDIquant::createMassSpectrum(1, 1)),
#'   "peaks" = list(MALDIquant::createMassPeaks(1, 1)),
#'   "metadata" = tibble::tibble(name = "foo")
#' )
#' is_a_processed_spectra_list(foo)
is_a_processed_spectra_list <- function(process_spectra_list) {
  # List depth snippet from comment by https://stackoverflow.com/users/1201032/flodel
  # src: https://stackoverflow.com/a/13433689
  depth <- function(this) ifelse(is.list(this), 1L + max(vapply(this, depth, FUN.VALUE = integer(1))), 0L)

  if (depth(process_spectra_list) != 3) {
    if (depth(process_spectra_list) == 2) {
      stop(
        "The processed_spectra object is not a list of lists as expected, but close enough!\n",
        "Please wrap the provided object in list(processed_spectra)."
      )
    } else {
      stop(
        "The processed_spectra object is not a list of lists as expected!"
      )
    }
  }
  if (typeof(process_spectra_list[[1]]) != "list") {
    stop(
      "The list does not contain list objects ",
      "produced by `maldipickr::process_spectra()` as expected."
    )
  }
  object_names <- Map(base::names, process_spectra_list) %>%
    base::unique() %>%
    base::unlist()
  if (length(object_names) != 3 || any(object_names != c("spectra", "peaks", "metadata"))) {
    stop(
      "The list does not contain the three expected named objects ",
      "(spectra, peaks and metadata) produced by `maldipickr::process_spectra()`."
    )
  }
  if (base::class(process_spectra_list[[1]][["spectra"]][[1]]) != "MassSpectrum") {
    stop(
      "The 'spectra' list is not a MALDIquant::MassSpectrum object!"
    )
  }
  if (base::class(process_spectra_list[[1]][["peaks"]][[1]]) != "MassPeaks") {
    stop(
      "The 'spectra' list is not a MALDIquant::MassPeaks object!"
    )
  }
  if (any(base::class(process_spectra_list[[1]]$metadata) != c("tbl_df", "tbl", "data.frame"))) {
    stop(
      "The 'metadata' is not a tibble!"
    )
  }
  return(TRUE)
}
