% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_posterior_diagnostics.R
\name{plot_posterior_stan}
\alias{plot_posterior_stan}
\title{Plotting posterior distributions}
\usage{
plot_posterior_stan(
  obj,
  param = c("prior", "variance", "stdev", "precision"),
  prior = FALSE
)
}
\arguments{
\item{obj}{An object from \code{inference_stan}}

\item{param}{A string indicating parameterization of plot.
\code{"prior"} for scale of parameters,
\code{"variance"}, \code{"stdev"} and \code{"precision"} also possible.}

\item{prior}{Include prior in the plot? Only possible for \code{param = "prior"}.
Note that if Jeffreys' prior is used for the total variance, it will not be included in the plot.}
}
\value{
A \link[ggplot2]{ggplot} with the posterior distributions.
See also \link[makemyprior]{makemyprior_plotting}.
}
\description{
Function for plotting the posterior distributions of the random effect variances
on the scale of the tree parameterization.
}
\examples{


if (interactive() && requireNamespace("rstan")){
  ex_prior <- makemyprior_example_model()
  res_stan <- inference_stan(ex_prior, iter = 100)
  # Note: For reliable results, increase the number of iterations (e.g., 'iter = 2000')
  plot_posterior_stan(res_stan)
}

}
\keyword{plot}
