% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive_fill.R
\name{interactive_fill}
\alias{interactive_fill}
\title{interactive filling}
\usage{
interactive_fill(
  image,
  color,
  refcolor = NULL,
  resolution = 0.1,
  return_param = FALSE
)
}
\arguments{
\item{image}{a magick image object}

\item{color}{a valid color string such as "navyblue" or "#000080". Use "none" for transparency.}

\item{refcolor}{if set, fuzz color distance will be measured against this color, not the color of the starting point. Any color (within fuzz color distance of the given refcolor), connected to starting point will be replaced with the color. If the pixel at the starting point does not itself match the given refcolor (according to fuzz) then no action will be taken.}

\item{resolution}{resolution of slider of fuzz}

\item{return_param}{If return_param is TRUE, returns a list values of point and fuzz. If return_param is FALSE, returns a magick image object.}
}
\value{
a magick image object or a list of values of point and fuzz
}
\description{
Using image_fill of 'magick' interactively.
point and fuzz are parameters of image_fill. See reference manual of 'magick' for detail.
}
\examples{
\donttest{
interactive_fill(wizard, "black")
}
}
\author{
Shota Ochi
}
