% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magi-package.R
\name{summary.magioutput}
\alias{summary.magioutput}
\title{Summary of parameter estimates from \code{magioutput} object}
\usage{
\method{summary}{magioutput}(
  object,
  sigma = FALSE,
  par.names,
  est = "mean",
  lower = 0.025,
  upper = 0.975,
  digits = 3,
  ...
)
}
\arguments{
\item{object}{a \code{magioutput} object.}

\item{sigma}{logical; if true, the noise levels \eqn{\sigma} will be included in the summary.}

\item{par.names}{vector of parameter names for the summary table. If provided, should be the same length as the number of parameters in \eqn{\theta}, or the combined length of \eqn{\theta} and \eqn{\sigma} when \code{sigma = TRUE}.}

\item{est}{string specifying the posterior quantity to treat as the estimate. Default is \code{est = "mean"}, which treats the posterior mean as the estimate. Alternatives are the posterior median (\code{est = "median"}, taken component-wise) and the posterior mode (\code{est = "mode"}, approximated by the MCMC sample with the highest log-posterior value).}

\item{lower}{the lower quantile of the credible interval, default is 0.025.}

\item{upper}{the upper quantile of the credible interval, default is 0.975.}

\item{digits}{integer; the number of significant digits to print.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
Returns a matrix where rows display the estimate, lower credible limit, and upper credible limit of each parameter.
}
\description{
Computes a summary table of parameter estimates from the output of \code{MagiSolver}
}
\details{
Computes parameter estimates and credible intervals from the MCMC samples. By default, the posterior mean is treated as the parameter estimate, and \code{lower = 0.025} and \code{upper = 0.975} produces a central 95\% credible interval.
}
\examples{
# Set up odeModel list for the Fitzhugh-Nagumo equations
fnmodel <- list(
  fOde = fnmodelODE,
  fOdeDx = fnmodelDx,
  fOdeDtheta = fnmodelDtheta,
  thetaLowerBound = c(0, 0, 0),
  thetaUpperBound = c(Inf, Inf, Inf)
)

# Example FN data
data(FNdat)

# Create magioutput from a short MagiSolver run (demo only, more iterations needed for convergence)
result <- MagiSolver(FNdat, fnmodel, control = list(nstepsHmc = 5, niterHmc = 100)) 

summary(result, sigma = TRUE, par.names = c("a", "b", "c", "sigmaV", "sigmaR"))
}
