% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimReduce.R
\name{dimReduce}
\alias{dimReduce}
\title{dimReduce}
\usage{
dimReduce(x, dim_exclude = NULL)
}
\arguments{
\item{x}{MAgPIE object which should be reduced}

\item{dim_exclude}{Vector with names of dimensions which must not be reduced}
}
\value{
The reduced MAgPIE object
}
\description{
Remove dimensions which contain identical data for all elements in it
}
\examples{

 #create data with 5 identical scenarios
 p <- add_dimension(population_magpie,nm = paste0("scen",1:5))
 p
 dimReduce(p)
 
 #set years to same value
 p[,,] <- setYears(p[,1,], NULL)
 p
 dimReduce(p)
 
 #set regions to same value
 p[,,] <- setCells(p[1,,], "GLO")
 p
 dimReduce(p)

}
\seealso{
\code{\link{add_dimension}}
}
\author{
Jan Philipp Dietrich
}
