% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08-data_visualize.R
\name{dataset_visualize}
\alias{dataset_visualize}
\title{Generate a web-based bookdown visual report of a dataset}
\usage{
dataset_visualize(
  dataset = tibble(id = as.character()),
  bookdown_path,
  data_dict = data_dict_extract(dataset),
  group_by = NULL,
  taxonomy = NULL,
  valueType_guess = FALSE,
  overwrite = FALSE,
  render = "html",
  .summary_var = NULL,
  .dataset_name = NULL
)
}
\arguments{
\item{dataset}{A tibble identifying the input dataset observations
associated to its data dictionary.}

\item{bookdown_path}{A character string identifying the folder path where the
bookdown report will be saved.}

\item{data_dict}{A list of tibble(s) representing meta data of an
associated dataset. Automatically generated if not provided.}

\item{group_by}{A character string of one column in the dataset that can be
taken as a grouping column. The visual element will be grouped and displayed
by this column.}

\item{taxonomy}{A tibble identifying the scheme used for variables
classification.}

\item{valueType_guess}{Whether the output should include a more accurate
valueType that could be applied to the dataset. FALSE by default.}

\item{overwrite}{whether to overwrite existing files. FALSE by default.}

\item{render}{Output format of the visual report. To date, the format can
only be 'html', but will be expand to other formats in the future.}

\item{.summary_var}{A list which is the summary of the variables.}

\item{.dataset_name}{A character string specifying the name of the dataset
(used for internal processes and programming).}
}
\value{
A bookdown folder containing files in the specified output folder. To
open the file in browser, open 'docs/index.html'. Or use
\code{\link[=bookdown_open]{bookdown_open()}}
}
\description{
Generates a visual report for a dataset in an HTML bookdown document. The
report provides figures and descriptive statistics for each variable to
facilitate the assessment of input data. Statistics and figures are
generated according to variable data type. The report can be used to help
assess data structure, coherence across elements, and taxonomy or
data dictionary formats. The summaries and figures provide additional
information about variable distributions and descriptive statistics.
The charts and tables are produced based on their data type. The variable
can be grouped using \code{group_by} parameter, which is a (categorical) column
in the dataset. The user may need to use \code{\link[=as.factor]{as.factor()}} in this context. To
fasten the process (and allow recycling object in a workflow) the user can
feed the function with a \code{.summary_var}, which is the output of the function
\code{\link[=dataset_summarize]{dataset_summarize()}} of the column(s) \code{col} and  \code{group_by}. The summary
must have the same parameters to operate.
}
\details{
A dataset must be a data frame-like object and can be associated with a
data dictionary. If no data dictionary is provided, a minimum workable
data dictionary will be generated as needed by relevant functions.
An identifier \code{id} column for sorting can be specified by the user. If
specified, the \code{id} values must be non-missing and will be used in functions
that require it. If no identifier column is specified, indexing is handled
automatically by the function.

A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.

The valueType is a property of a variable and is required in certain
functions to determine the handling of the variables. The valueType refers
to the OBiBa-internal type of a variable. It is specified in a data
dictionary in a column \code{valueType} and can be associated with variables as
attributes. Acceptable valueTypes include 'text', 'integer', 'decimal',
'boolean', datetime', 'date'). The full list of OBiBa valueType
possibilities and their correspondence with R data types are available using
\link{valueType_list}.

A taxonomy is classification scheme that can be defined for variable
attributes. If defined, a taxonomy must be a data frame-like object. It must
be compatible with (and is generally extracted from) an Opal environment. To
work with certain functions, a valid taxonomy must contain at least the
columns 'taxonomy', 'vocabulary', and 'terms'. In addition, the taxonomy
may follow Maelstrom research taxonomy, and its content can be evaluated
accordingly, such as naming convention restriction, tagging elements,
or scales, which are specific to Maelstrom Research. In this particular
case, the tibble must also contain 'vocabulary_short', 'taxonomy_scale',
'vocabulary_scale' and 'term_scale' to work with some specific functions.
}
\examples{
{

dataset <- DEMO_files$dataset_TOKYO['height']
data_dict <-
  data_dict_filter(
    DEMO_files$dd_TOKYO_format_maelstrom,
    filter_var = "name == 'height'")
      
.summary_var <- DEMO_files$summary_var
  
bookdown_path <- tempdir()
dataset_visualize(
  dataset, data_dict,
  .summary_var =.summary_var, 
  bookdown_path = bookdown_path,
  overwrite = TRUE)
  
# To open the file in browser, open 'bookdown_path/docs/index.html'. 
# Or use bookdown_open(bookdown_path) function

}

}
\seealso{
\code{\link[=bookdown_open]{bookdown_open()}}
}
