% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{data_dict_ungroup}
\alias{data_dict_ungroup}
\title{Ungroup data dictionary}
\usage{
data_dict_ungroup(data_dict)
}
\arguments{
\item{data_dict}{A list of tibble(s) representing meta data to be
transformed.}
}
\value{
A list of tibble(s) identifying a workable data dictionary structure.
}
\description{
Ungroups the data dictionary element(s). This function ungroups both the
'Variables' and 'Categories' elements (if both are grouped tibbles).
This function is analogous to running \code{\link[dplyr:group_by]{dplyr::ungroup()}}.
\code{\link[=data_dict_group_by]{data_dict_group_by()}} allows to group a data dictionary and this function
reverses the effect.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.
}
\examples{
{

# use DEMO_files provided by the package
# Create a list of data dictionaries where the column 'table' is added to 
# refer to the associated dataset. The object created is not a 
# data dictionary per say, but can be used as a structure which can be 
# shaped into a data dictionary.

library(dplyr)

data_dict_list <- DEMO_files[
    c('dd_MELBOURNE_1_format_maelstrom',
      'dd_MELBOURNE_2_format_maelstrom')] \%>\%
  data_dict_list_nest(name_group = 'table') \%>\%
  data_dict_group_by(col = "table")
    
 data_dict_ungroup(data_dict_list)
}

}
\seealso{
\code{\link[dplyr:group_by]{dplyr::ungroup()}}
\code{\link[=data_dict_group_by]{data_dict_group_by()}}
}
