% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-unit_checks.R
\name{check_data_dict_valueType}
\alias{check_data_dict_valueType}
\title{Assess a data dictionary for non-valid valueType values}
\usage{
check_data_dict_valueType(data_dict)
}
\arguments{
\item{data_dict}{A list of tibble(s) representing meta data to be evaluated.}
}
\value{
A tibble providing non-standard valueType declared in a data dictionary.
}
\description{
Generates a tibble report of any variable with a valueType that is not in the
list of allowed valueType values. This function also assesses if the
valueType is compatible with any associated categorical values declared.
This report can be used to help assess data structure, presence of fields,
coherence across elements, and taxonomy or data dictionary formats.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.

The valueType is a property of a variable and is required in certain
functions to determine the handling of the variables. The valueType refers
to the OBiBa-internal type of a variable. It is specified in a data
dictionary in a column \code{valueType} and can be associated with variables as
attributes. Acceptable valueTypes include 'text', 'integer', 'decimal',
'boolean', datetime', 'date'). The full list of OBiBa valueType
possibilities and their correspondence with R data types are available using
\link{valueType_list}.
}
\examples{
{

# use DEMO_files provided by the package

data_dict <- DEMO_files$`dd_TOKYO_format_maelstrom_tagged - ERROR`
check_data_dict_valueType(data_dict)

}

}
