% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhrr.R
\name{mhrr}
\alias{mhrr}
\title{Calculating measures of Risk including Risk Ratio}
\usage{
mhrr(
  data,
  ...,
  by,
  strata = NULL,
  exp_value = NULL,
  case_value = NULL,
  measure = "ratio",
  plot = TRUE,
  na.rm = FALSE,
  rnd = 3
)
}
\arguments{
\item{data}{Dataset}

\item{...}{Variable or multiple variables
Colon separator \code{:} can be used to specify multiple variables.}

\item{by}{Varaiable for cross-tabulation}

\item{strata}{Variable for stratification}

\item{exp_value}{value for exposure as reference}

\item{case_value}{value for outcome as reference}

\item{measure}{choose different measures related to risks. This is not
case-sensitive.

By default, measure is \code{RATIO} and calculates \verb{rate ratio}.

For Risk Ratio;

\code{ratio} = \verb{Risk Ratio}

\code{diff} = \verb{Risk Diff.} (\verb{Risk Difference})

\code{ar} = \verb{Attributable Risk}, specifically \verb{Attributable Risk Percent} or
\verb{Proportional Attributable Risk} (This is not converted to Percent scale)

\code{par} = \verb{Pop. AR} (\verb{Population Attributable Risk})

\code{efficacy} = \code{Efficacy} of a certain treatment or exposure.

For Mantel-Haenszel estimates,

\code{ratio} = \verb{Risk Ratio}

\code{diff} = \verb{Risk Diff.} (\verb{Risk Difference})}

\item{plot}{logical value to display plots of risk ratios or differences
including MH estimates across a categorical variable}

\item{na.rm}{A logical value to specify missing values, \code{NA} in the table}

\item{rnd}{specify rounding of numbers. See \code{\link{round}}.}
}
\description{
\code{mhrr()} calculates different measures of risk including risk
ratios (RR) as well as
Mantel-Haenszel pooled estimates.
}
\details{
Value can be set as baseline by specifying \code{exp_value}. This is used
when the exposed and case values are not in the right place.

It produces a table with Odds Ratio,95\% CI as well as
p-value. If \code{strata} is specified, \code{Mantel-Haenzsel} Pooled
estimates of \verb{Odds Ratio} is generated along with Chi-sqaured test for heterogeneity.

The following entails formulas used for calculating measures.

\deqn{Risk among exposed, R1 = A / (A + C)}

\deqn{Risk among unexposed, R0 = B / (B + D)}

\deqn{Number among exposed, N1 = A + B}

\deqn{Number among unexposed, N0 = C + D}

\deqn{Number among diseased, D1 = A + C}

\deqn{Number among health, D0 = B + D}

\deqn{Sample size, N = N1 + N0}

\strong{Risk Ratio, RR}

Risk ratio is sometimes called as relative risk (RR).

\deqn{Risk Ratio = R1 / R0}
\subsection{using delta method, See page 155 of Essential Medical Statistics}{

\deqn{SE(log RR) = sqrt(1/A - 1/N1 + 1/C - 1/N0)}

\deqn{Lower Limit of CI = exp(log RR - 1.96 x SE(log RR)) }

\deqn{Upper Limit of CI = exp(log RR + 1.96 x SE(log RR)) }
}

\subsection{Test of null hypothesis for Risk Ratio}{

\deqn{z = log RR / SE(log RR)}
}

\subsection{Mantel-Haenszel Method for RR}{

k = Strata

\deqn{RR_MH = \sum{Ak x N0k / Nk} / \sum{Ck x N1k / Nk}}

\deqn{SE(log RR_MH) = \sqrt{ \sum{D1k x N1k x N0k / Nk^2 - Ak x Ck / Nk} / \sum{Ak x N0k / Nk} x \sum{Ck x N1k / Nk}}}

\deqn{Lower Limit of CI = exp(log RR_MH - 1.96 x SE(log RR_MH)) }

\deqn{Upper Limit of CI = exp(log RR_MH + 1.96 x SE(log RR_MH)) }
}

\subsection{Mantel–Haenszel test statistic}{

A test of association (H0: RR_MH = 1 cohort studies; H0: RR_MH = 1 case–control studies)
is carried out with the Mantel–Haenszel test statistic using chi-squared distribution:

\deqn{x2_MH = (\sum{Ak} - \sum{N1k x M1k / Nk})^2 / \sum{N1k x N0k x M1k x M0k / Nk^2 x (Nk - 1)}}

Degree of freedom is 1.

\strong{Risk Difference, RD}

\deqn{RD = R1 - R0}

\deqn{SE(RD) = \sqrt{(R1 (1 - R1) / N1) + R0 (1 - R0) / N0}}

\deqn{Lower Limit of CI = RD - (1.96 x SE(RD))}

\deqn{Upper Limit of CI = RD + (1.96 x SE(RD))}
}

\subsection{Test that the difference between two proportions is zero}{

\deqn{z = RD / SE(RD)}
}

\subsection{Mantel-Haenszel Method for Risk Difference}{

This method was proposed by Cochran and by Mantel and Haenszel.
Cochran proposed using the weights nkmk/Nk,
which he showed empirically to be optimal in testing a hypothesis of zero
risk difference if the risk differences were constant on a logit scale. These
weights will be called the Cochran-Mantel-Haenszel (CMH) weights and the
estimator based on these weights will be called the CMH estimator.
See details at Thomas W. O'Gorman (1994) doi.org/10.1016/0197-2456(94)90017-5

k = strata

\deqn{Weight of CMH estimator, W = N1k x N2k / Nk}

\deqn{RD_CMH = \sum{Wk x RDk} / \sum{Wk}}

\deqn{Variance of RD_CMH, Lk = (Ak x Bk x N0^3 + Ck x Dk x N1^3) / N1k x N0k x Nk^2}

\deqn{Lower limit of CI = RD_CMH - (1.96 x \sum{Lk}^1/2 / \sum(Wk))}

\deqn{Lower limit of CI = RD_CMH + (1.96 x \sum{Lk}^1/2 / \sum(Wk))}
}

\subsection{Mantel–Haenszel test statistic: Same as Risk Ratio}{

A test of association (H0: RD_CMH = 1 cohort studies; H0: RD_CMH = 1 case–control studies)
is carried out with the Mantel–Haenszel test statistic using chi-squared distribution:

\deqn{x2_MH = (\sum{Ak} - \sum{N1k x M1k / Nk})^2 / \sum{N1k x N0k x M1k x M0k / Nk^2 x (Nk - 1)}}

Degree of freedom is 1.

\strong{Population Attributable Risk, PAR}

A measure of the proportion of individuals in the total population with
the disease attributed to exposure to the risk factor is given by the
attributable risk (AR). P is the prevalence of the risk factor in the population
and RR is the relative risk for disease associated with the risk factor.

\deqn{PAR = P (RR - 1) / (1 + P (RR - 1))}

\deqn{Lower limit of CI = P (RR_LL - 1) / (1 + P (RR_LL - 1))}

\deqn{Upper limit of CI = P (RR_UL - 1) / (1 + P (RR_UL - 1))}

RR_LL = Lower limit of CI of RR

RR_UL = Upper limit of CI of RR

\strong{Attributable Risk, AR}

The function produces Attributable Risk percent (Raw form = not converted to 100\%).

\deqn{AR = RR - 1 / RR}

\deqn{SE(AR) = \sqrt{D1 / N (1 - D1 / N) (1/N1 + 1/N0)}}

\strong{Efficacy}

The efficacy of a treatment or intervention is measured by the proportion of cases
that it prevents. Efficacy is directly calculated from the risk ratio
comparing disease outcome in the treated versus control group. For a successful
treatment (or intervention) this ratio will be less than 1.

\deqn{Efficacy = 1 - RR}

\deqn{Lower limit of CI = 1- RR x exp(1.96 x SE(log RR))}

\deqn{Lower limit of CI = 1- RR / exp(1.96 x SE(log RR))}
}
}
\examples{


### Demonstration: Calculating Risk Ratios


## Essential Medical Statistics, Betty R. Kirkwood, Second Edition
## Chapter 16, Table 16.4, Page 154
## For Risk Ratio
lung <- expandTables(
    c(39, 29961, 6, 59994),
    exp_name = "smoking",
    exp_lvl = c("Smokers", "Non-smokers"),
    case_name = "cancer",
    case_lvl = c("Yes", "No")
)

## label variable and dataset
lung <- labelVar(lung,
                 c(smoking, cancer),
                 c("Smoking versus non-smoking", "Lung cancer: Yes or No"))
lung <- labelData(lung,
            "Association between smoking and lung cancer (Follow up one year)")

## check dataset
codebook(lung)

## calculate RR
mhrr(lung, smoking, by = cancer, exp_value = "Smokers", case_value = "Yes")

## calculate risk difference
mhrr(lung, smoking, by = cancer, exp_value = "Smokers", case_value = "Yes",
     measure = "diff", rnd = 5)
## Risk difference = 0.0012 = 0.12 \%


}
\references{
\enumerate{
\item  Betty R. Kirkwood, Jonathan A.C. Sterne (2006, ISBN:978–0–86542–871–3)
\item B. Burt Gerstman (2013, ISBN:978-1-4443-3608-5)
\item Douglas G Altman (2005, ISBN:0 7279 1375 1)
}
}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
