% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-attachments.R
\name{list_attachments}
\alias{list_attachments}
\title{List attachments and content-disposition types}
\usage{
list_attachments(msg_list)
}
\arguments{
\item{msg_list}{A \code{list} containing the messages (body or text) fetched
from the server.}
}
\value{
A \code{list} of \code{data.frames} containing the filenames and its
  \code{Content-Disposition} types for each fetched message.
}
\description{
List attachments and content-disposition types
}
\note{
Please, note that this is an independent function and not an R6 method
  that depends on the connection object. Therefore, it should be called alone
  without the ImapCon object.
}
\examples{
\dontrun{
con$select_folder(name = "INBOX")
# do a search followed by a fetch operation, then extract the attachments' list
out <- con$search_string(expr = "@k-state.edu", where = "FROM") \%>\%
  con$fetch_body()
att_list <- list_attachments(msg_list = out)

# or
att_list <- con$search_string(expr = "@k-state.edu", where = "FROM") \%>\%
  con$fetch_body() \%>\%
  list_attachments()
}
}
\seealso{
Other attachments: 
\code{\link{ImapCon}}
}
\concept{attachments}
