% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/followingNetwork.R
\name{getFactionSizeRatio}
\alias{getFactionSizeRatio}
\title{getFactionSizeRatio function}
\usage{
getFactionSizeRatio(adjMat, members)
}
\arguments{
\item{adjMat}{is an adjacency matrix of a dominant-distribution network.}

\item{members}{is a list of member IDs of a given faction.}
}
\value{
This function returns a faction size ratio of a given faction.
}
\description{
getFactionSizeRatio is a support function for calculating a faction size ratio of a given faction.
A faction size ratio is a number of edges that connect between faction-member nodes divided by a number of total nodes within a following network.
}
\examples{

# Given an example of adjacency matrix
A<-matrix(FALSE,5,5)
A[2,1]<-TRUE
A[c(3,4),2]<-TRUE

# Get a faction size ratio of a given faction

getFactionSizeRatio(adjMat=A,members=c(1,2,3,4))

}
