% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m2_utility.R
\name{m2_utility}
\alias{m2_utility}
\alias{m2_name}
\alias{m2_name<-}
\alias{m2_meta}
\alias{m2_meta<-}
\alias{m2_structure}
\alias{m2_exists}
\alias{m2_ls}
\alias{m2_rm}
\alias{m2_getwd}
\title{Utility tools for M2}
\usage{
m2_name(x)

m2_name(x) <- value

m2_meta(x, m2_attr)

m2_meta(x, m2_attr) <- value

m2_structure(x = NA, m2_name, m2_class, m2_meta, base_class)

m2_exists(name)

m2_ls(all.names = FALSE)

m2_rm(name)

m2_getwd()
}
\arguments{
\item{x}{an object of class \code{m2}}

\item{value}{the value to assign}

\item{m2_attr}{the name of an M2 attribute}

\item{m2_name}{\code{m2_name}  M2 attribute}

\item{m2_class}{\code{m2_class} M2 attribute}

\item{m2_meta}{\code{m2_meta}  M2 attribute}

\item{base_class}{a base class; an R class to use for dispatching
if there is no relevant method for the other classes (e.g.
\code{m2})}

\item{name}{a string; the name of a M2 object}

\item{all.names}{if \code{TRUE}, all registered Macaulay2
variables, including ones internally used by m2r, will be
returned}
}
\description{
Utility tools for M2
}
\examples{

\dontrun{ requires Macaulay2

m2("a = 5")
m2_ls()
m2_exists("a")
m2("b = 1")
m2_exists(c("a","b","c"))

m2_getwd()

x <- 1
class(x) <- "m2"
attr(x, "m2_meta") <- list(a = 1, b = 2)
m2_meta(x)
m2_meta(x, "b")
m2_meta(x, "b") <- 5
m2_meta(x, "b")

# R <- ring(c("x1", "x2", "x3"))
# m2_name(R)
# m2(sprintf("class \%s", m2_name(R)))
# m2_ls()
# m2_rm(m2_name(R))
# m2_ls()
# m2(paste("class", m2_name(R)))

m2_ls()
m2_ls(all.names = TRUE)


}
}
