% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlta.R
\name{mlta}
\alias{mlta}
\title{Mixture of Latent Trait Analyzers}
\usage{
mlta(X, G, D, wfix = FALSE, nstarts = 3, tol = 0.1^2,
  maxiter = 250, pdGH = 21)
}
\arguments{
\item{X}{(\code{N} x \code{M}) binary incidence matrix}

\item{G}{number of groups}

\item{D}{dimension of the continuous latent variable}

\item{wfix}{Logical. Fit the parsiomonius model with the w parameters equal across groups. Default \code{wfix = FALSE}}

\item{nstarts}{number of starts.  Default \code{nstarts = 3}}

\item{tol}{desired tolerance for convergence. Default \code{tol = 0.1^2}}

\item{maxiter}{maximum number of iterations. Default \code{maxiter = 500}}

\item{pdGH}{number of quadrature points for the Gauss-Hermite quadrature. Default \code{pdGH = 21}}
}
\value{
List containing the following information for each model fitted:
\itemize{
\item \code{b} matrix containing intercepts for the logistic response function
\item \code{w} array containing slopes for the logistic response function
\item \code{eta} \eqn{\eta_g} is the mixing proportion for the group \eqn{g (g = 1,..., G)}, that corresponds to the prior probability that a randomly chosen sender node is in the g-th group. 
\item \code{mu} (\code{N} x \code{D} x \code{G}) array containing posterior means for the latent variable
\item \code{C} (\code{D} x \code{D} x \code{N} x \code{G}) array containing posterior variances for the latent variable
\item \code{z} (\code{N} x \code{G}) matrix containing posterior probability for each sender node to belong to each group
\item \code{LL} log likelihood
\item \code{BIC} Bayesian Information Criterion (BIC) (Schwarz (1978))
}
If multiple models are fitted the output contains also tables to compare the log likelihood and BIC for all models fitted.
}
\description{
Mixture of latent trait analyzers (MLTA) has been introduced by Gollini and Murphy (2014) and Gollini (in press) to identify groups assuming the existence of a latent trait describing the dependence structure between receiver nodes within groups of sender nodes and therefore capturing the heterogeneity of sender nodes' behaviour within groups. The function \code{mlta} makes use of a variational inferential approach. For more details see Gollini, I. (in press) and Gollini, I., and Murphy, T. B. (2014).
}
\examples{
### Simulate Bipartite Network
set.seed(1)
X <- matrix(rbinom(4 * 12, size = 1, prob = 0.4), nrow = 12, ncol = 4)

resMLTA <- mlta(X, G = 2, D = 1)
}
\references{
Gollini, I. (in press) 'A mixture model approach for clustering bipartite networks', Challenges in Social Network Research Volume in the Lecture Notes in Social Networks (LNSN - Series of Springer). Preprint: \url{https://arxiv.org/abs/1905.02659}.

Gollini, I., and Murphy, T. B. (2014), 'Mixture of Latent Trait Analyzers for Model-Based Clustering of Categorical Data', Statistics and Computing, 24(4), 569-588 \url{http://arxiv.org/abs/1301.2167}.
}
\seealso{
\code{\link{lta}} \code{\link{lca}}
}
