% Generated by roxygen2 (4.0.1): do not edit by hand
\name{lunar.metric.mean}
\alias{lunar.metric.mean}
\title{Average Lunar Metrics}
\usage{
lunar.metric.mean(x, towards = -6, ..., by = c("date", "hours", "day",
  "night"), type = c("illumination", "distance"))
}
\arguments{
\item{x}{A vector of \code{\link[base]{Date}} values.}

\item{towards}{The directed window size from \code{x} in days.
By default the window looks back 7 days including \code{x}.}

\item{by}{The exposure interval and integration basis.
The default is to represent a day's illumination by
the illumination at 12 noon UT.  The other options integrate
midrange illuminations over hours.  Options 'day' and 'night'
are not currently implemented, but will be used to limit
exposure intervals.
The use of an unimplemented option
in a function call will result in a \code{NULL} value
being returned.}

\item{type}{Whether illumination or distance metrics are to be returned.
The use of an unimplemented option
in a function call will result in a \code{NULL} value
being returned.}

\item{...}{Other optional arguments are ignored.}
}
\description{
Returns an average measurement around specified dates.
}
\details{
This in an internal support function that integrates a lunar
  measurement over time using step sizes of days or hours.
}
\examples{
\dontrun{
lunar.metric.mean(as.Date("2004-03-24"), type="illumination")
}
}
\seealso{
\code{\link{lunar.illumination}}

\code{\link{lunar.distance}}
}
\keyword{covariate}
\keyword{lunar}
\keyword{metric}
\keyword{moon}

