% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/index.R
\docType{methods}
\name{Extract by index}
\alias{Extract by index}
\alias{[[,CategoryLabel,ANY,ANY-method}
\alias{[[,ExpVarRasterList,ANY,ANY-method}
\title{Extract by index}
\usage{
\S4method{[[}{ExpVarRasterList,ANY,ANY}(x, i, j, ...)

\S4method{[[}{CategoryLabel,ANY,ANY}(x, i, j, ...)
}
\arguments{
\item{x}{an object of class ExpVarRasterList or any object inheriting from the
virtual class CategoryLabel}

\item{i}{layer number (if 'x' inherits from a RasterStack) or list index (if
'x' stores data as a list)}

\item{j}{numeric (not used)}

\item{...}{additional arguments (none)}
}
\description{
\code{object[[i]]} can be used to extract individual objects from container
classes such as \code{ExpVarRasterList}, \code{PredictiveModelList}, \code{PredictionList} and
\code{PerformanceList}.
}
\examples{
## Plum Island Ecosystems

## Load observed land use maps
obs <- ObsLulcRasterStack(x=pie,
                   pattern="lu",
                   categories=c(1,2,3),
                   labels=c("forest","built","other"),
                   t=c(0,6,14))

summary(obs[[1]])
summary(obs[[1:2]])
}

