% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsnstat_macrodata.R
\name{lsnstat_macrodata}
\alias{lsnstat_macrodata}
\title{R companion of 'La Societe Nouvelle' stats API services}
\usage{
lsnstat_macrodata(dataset, filter_list, filters, sort, verbose = T)
}
\arguments{
\item{dataset}{dataset requested : list available at \url{https://docs.lasocietenouvelle.org/series-donnees} (required)}

\item{filter_list}{filters to apply : R list of dataset 'params' available through function \link{lsnstat_metadata} or \link{get_lsn_dataset_list} (optional)}

\item{filters}{filters to apply : formatted list of dataset 'params' available through function \link{lsnstat_metadata} or \link{get_lsn_dataset_list} (optional)}

\item{sort}{Sort the dataset by one or more 'params' available(s) through function \link{lsnstat_metadata} or \link{get_lsn_dataset_list} (optional).}

\item{verbose}{display or hide supplementary informations.}
}
\value{
A \code{\link[=data.frame]{data.frame()}}.
}
\description{
R companion of 'La Societe Nouvelle' stats API services
}
\examples{

#GET macro footprint : Greenhouse gases emissions intensities
# for sector "C19" between 2015 and 2021

lsnstat_macrodata(dataset = "macro_fpt",
                  filter_list = list(indic = 'GHG',year = 2015:2021,industry = 'C19'))

#GET macro footprint trend : Energy uses intensities
# for sector "C28" between 2025 and 2030

lsnstat_macrodata(dataset = "macro_fpt_trd",
                  filters = "indic=NRG&year=2025+2026+2027+2028+2029+2030&industry=C28")

# GET sectoral value-added, production and intermediate consumption from FIGARO
# for sector 'O84' in 2010 and 2030

lsnstat_macrodata("figaro_main_aggregates",list(aggregate = c('X','VA','P2'),
                                                industry = 'O84',
                                                year = c("2010","2030")),
                                                sort = c('country','value'))

}
