% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsgl_subsampling.R
\name{lsgl.subsampling}
\alias{lsgl.subsampling}
\title{Subsampling}
\usage{
lsgl.subsampling(x, y, intercept = TRUE, weights = NULL,
  grouping = factor(1:ncol(x)), groupWeights = c(sqrt(ncol(y) *
  table(grouping))), parameterWeights = matrix(1, nrow = ncol(y), ncol =
  ncol(x)), alpha = 1, lambda, train, test, collapse = FALSE,
  max.threads = 2L, algorithm.config = lsgl.standard.config)
}
\arguments{
\item{x}{design matrix, matrix of size \eqn{N \times p}.}

\item{y}{response matrix, matrix of size \eqn{N \times K}.}

\item{intercept}{should the model include intercept parameters.}

\item{weights}{sample weights, vector of size \eqn{N \times K}.}

\item{grouping}{grouping of features, a factor or vector of length \eqn{p}. Each element of the factor/vector specifying the group of the feature.}

\item{groupWeights}{the group weights, a vector of length \eqn{m} (the number of groups).}

\item{parameterWeights}{a matrix of size \eqn{K \times p}.}

\item{alpha}{the \eqn{\alpha} value 0 for group lasso, 1 for lasso, between 0 and 1 gives a sparse group lasso penalty.}

\item{lambda}{the lambda sequence for the regularization path.}

\item{train}{a list of training samples, each item of the list corresponding to a subsample.
Each item in the list must be a vector with the indices of the training samples for the corresponding subsample.
The length of the list must equal the length of the \code{test} list.}

\item{test}{a list of test samples, each item of the list corresponding to a subsample.
Each item in the list must be vector with the indices of the test samples for the corresponding subsample.
The length of the list must equal the length of the \code{training} list.}

\item{collapse}{if \code{TRUE} the results for each subsample will be collapse into one result (this is useful if the subsamples are not overlapping)}

\item{max.threads}{the maximal number of threads to be used.}

\item{algorithm.config}{the algorithm configuration to be used.}
}
\value{
\item{Yhat}{if \code{collapse = FALSE} then a list of length \code{length(test)} containing the predicted responses for each of the test sets. If \code{collapse = TRUE} a list of length \code{length(lambda)}}
\item{Y.true}{a list of length \code{length(test)} containing the true responses of the test samples}
\item{features}{number of features used in the models}
\item{parameters}{number of parameters used in the models.}
}
\description{
Linear multiple output subsampling using multiple possessors
}
\examples{

set.seed(100) # This may be removed, it ensures consistency of the daily tests

## Simulate from Y=XB+E, the dimension of Y is N x K, X is N x p, B is p x K

N <- 100 #number of samples
p <- 50 #number of features
K <- 25  #number of groups

B <- matrix(sample(c(rep(1,p*K*0.1),rep(0, p*K-as.integer(p*K*0.1)))),nrow=p,ncol=K)
X1 <- matrix(rnorm(N*p,1,1),nrow=N,ncol=p)
Y1 <- X1\%*\%B+matrix(rnorm(N*K,0,1),N,K)

##Do cross validation

train <- replicate(2, sample(1:N, 50), simplify = FALSE)
test <- lapply(train, function(idx) (1:N)[-idx])

lambda <- lapply(train, function(idx)
	lsgl.lambda(X1[idx,], Y1[idx,], alpha = 1, d = 15L, lambda.min = 5, intercept = FALSE))

fit.sub <- lsgl.subsampling(X1, Y1, alpha = 1, lambda = lambda,
	train = train, test = test, intercept = FALSE)

Err(fit.sub)

}
\author{
Martin Vincent
}

