% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{KMeansW}
\alias{AssignCluster}
\alias{ComputeMeans}
\alias{KMeansW}
\title{C++ Function for Weighted K-Means}
\usage{
ComputeMeans(cm, data, weight, nclust)

AssignCluster(data, weight, M, nclust)

KMeansW(nclust, start, data, weight, eps = 1e-08, IterMax = 100L)
}
\arguments{
\item{cm}{Numeric vector of class indicators.}

\item{data}{The concatenated data, with N rows and M columns. Currently, the columns are clustered.}

\item{weight}{The vector of length \code{nrows(data)} with weights with nonnegative elements.}

\item{nclust}{The number of clusters.}

\item{M}{Matrix of cluster means.}

\item{start}{The current cluster membership vector.}

\item{eps}{Numerical absolute convergence criteria for the K-means.}

\item{IterMax}{Integer giving the maximum number of iterations allowed for the K-means.}
}
\value{
A list with the folowing values.
\item{centers}{the \code{nclust} by M matrix \code{centers} of cluster means.} 
\item{cluster}{vector of length N with cluster memberships.} 
\item{loss}{vector of length \code{IterMax} with the first entries containing the loss.} 
\item{iterations}{the number of iterations used (corresponding to the number 
of nonzero entries in \code{loss})}
}
\description{
This function does a weighted K-means clustering.
}
\examples{
set.seed(1)
clustmem <- sample.int(n = 10, size = 100, replace = TRUE)
mat <- rbind(matrix(rnorm(30*4, mean = 3), nrow = 30), 
             matrix(rnorm(30*4, mean = -2), nrow = 30), 
             matrix(rnorm(40*4, mean = 0), nrow = 40))
wt <- runif(100)
testMeans <- lsbclust:::ComputeMeans(cm = clustmem, data = mat, weight = wt, nclust = 3)
testK <- lsbclust:::KMeansW(start = clustmem, data = mat, weight = wt, nclust = 3)
}

