% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_replicate_weights.R
\name{calc_replicate_weights}
\alias{calc_replicate_weights}
\title{Calculate replicate weights and summary statistics}
\usage{
calc_replicate_weights(data, method, k = 0)
}
\arguments{
\item{data}{list of background questionnaire data (typically generated by `cluster_gen`)}

\item{method}{replication method. Can be "Jackknife", "BRR" or "BRR Fay"}

\item{k}{deflating weight factor (used only when `method = "BRR Fay")}
}
\value{
list with data and, if requested, some statistics
}
\description{
Takes the output of `cluster_gen` to calculate the replicate weights as well as some summary statistics
}
\details{
Replicate weights can be calculated using the Jackknife for unstratified two-stage sample designs or Balanced Repeated Replication (BRR) with or without Fay's modification.
According to OECD (2015), PISA uses the Fay method with a factor of 0.5. This is why `k = .5` by default.
}
\note{
This function is essentially a big wrapper for `replicate_var`, applying that function on each element of an output of `cluster_gen`.
}
\examples{
data <- cluster_gen(c(3, 50))
calc_replicate_weights(data, "Jackknife")
calc_replicate_weights(data, "BRR")
calc_replicate_weights(data, "BRR Fay")
}
\references{
OECD (2015). Pisa Data Analysis Manual.
Rust, K. F., & Rao, J. N. K. (1996). Variance estimation for complex surveys using replication techniques. Statistical methods in medical research, 5(3), 283-310.
}
\seealso{
cluster_gen jackknife, jackknife_var
}
