% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simon2stage}
\alias{simon2stage}
\title{Simon's two-stage design}
\usage{
simon2stage(alpha, beta, piH0, pi, n_max = 110L)
}
\arguments{
\item{alpha}{Type I error rate (one-sided).}

\item{beta}{Type II error rate (1-power).}

\item{piH0}{Response probability under the null hypothesis.}

\item{pi}{Response probability under the alternative hypothesis.}

\item{n_max}{Upper limit for sample size, defaults to 110.}
}
\value{
A data frame containing the following variables:
\itemize{
\item \code{piH0}: Response probability under the null hypothesis.
\item \code{pi}: Response probability under the alternative hypothesis.
\item \code{alpha}: The specified one-sided significance level.
\item \code{beta}: The specified type II error.
\item \code{n}: Total sample size.
\item \code{n1}: Stage 1 sample size.
\item \code{r1}: Futility boundary for stage 1.
\item \code{r}: Futility boundary for stage 2.
\item \code{EN0}: Expected sample size under the null hypothesis.
\item \code{attainedAlpha}: Attained type 1 error.
\item \code{power}: Attained power.
\item \code{PET0}: Probability of early stopping under the null hypothesis.
\item \code{w_lower}: Lower bound of the interval for \code{w}.
\item \code{w_upper}: Upper bound of the interval for \code{w}.
\item \code{design}: Description of the design, e.g., minimax, admissible,
or optimal.
}

Here \code{w} is the weight in the objective function:
\code{w*n + (1-w)*EN0}.
}
\description{
Obtains Simon's two-stage minimax, admissible, and
optimal designs.
}
\examples{
simon2stage(0.05, 0.15, 0.1, 0.3)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
