% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hd}
\alias{hd}
\title{Integrated event probability over an interval with constant hazard}
\usage{
hd(
  j = NA_integer_,
  t1 = NA_real_,
  t2 = NA_real_,
  piecewiseSurvivalTime = 0L,
  lambda = NA_real_,
  gamma = 0L
)
}
\arguments{
\item{j}{The analysis time interval with constant hazard.}

\item{t1}{Lower bound of the analysis time interval.}

\item{t2}{Upper bound of the analysis time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{lambda}{A vector of hazard rates for the event. One for
each analysis time interval.}

\item{gamma}{The hazard rate for exponential dropout, or a vector of
hazard rates for piecewise exponential dropout.}
}
\value{
A value for the integrated probability of having an event
during an interval with constant hazard for a treatment
group with specified piecewise exponential survival and dropout
distributions.
}
\description{
Obtains the integration probability of having an event
during an interval with constant hazard.
}
\examples{
# Piecewise exponential survival with hazard 0.0533 in the first 6
# months, and hazard 0.0309 thereafter, and 5\% dropout by the end of
# 1 year.

hd(j = 1, t1 = 1, t2 = 3, piecewiseSurvivalTime = c(0, 6),
   lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
\keyword{internal}
