% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{zstatRateRatio}
\alias{zstatRateRatio}
\title{Miettinen-Nurminen Score Test Statistic for Two-Sample Rate Ratio}
\usage{
zstatRateRatio(
  rateRatioH0 = 1,
  t1 = NA_real_,
  y1 = NA_real_,
  t2 = NA_real_,
  y2 = NA_real_
)
}
\arguments{
\item{rateRatioH0}{The rate ratio under the null hypothesis.
Defaults to 1.}

\item{t1}{The exposure for the active treatment group.}

\item{y1}{The number of events for the active treatment group.}

\item{t2}{The exposure for the control group.}

\item{y2}{The number of events for the control group.}
}
\value{
The value of the score test statistic.
}
\description{
Obtains the Miettinen-Nurminen score test statistic for
two-sample rate ratio possibly with stratification.
}
\details{
The Mantel-Haenszel weights are used for stratified samples.
}
\examples{

zstatRateRatio(rateRatioH0 = 1, t1 = c(10,10), y1 = c(4,3),
               t2 = c(20,10), y2 = c(2,0))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
