% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{repeatedPValue}
\alias{repeatedPValue}
\title{Repeated p-values for group sequential design}
\usage{
repeatedPValue(
  k = NA_integer_,
  informationRates = NA_real_,
  p = NA_real_,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  spendingTime = NA_real_
)
}
\arguments{
\item{k}{Look number for the current analysis.}

\item{informationRates}{Information rates up to the current look, must be
increasing and less than or equal to 1.}

\item{p}{The raw p-values at look 1 to look \code{k}.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{spendingTime}{A vector of length \code{k} for the error spending
time at each analysis, must be increasing and less than or equal to 1. 
Defaults to missing, in which case, it is the same as 
\code{informationRates}.}
}
\value{
The repeated p-values at look 1 to look \code{k}.
}
\description{
Obtains the repeated p-values for a group sequential design.
}
\examples{

repeatedPValue(k = 3, informationRates = c(529, 700, 800)/800,
               p = c(0.2, 0.15, 0.1), typeAlphaSpending = "sfOF",
               spendingTime = c(0.6271186, 0.8305085, 1))

}
