% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{errorSpent}
\alias{errorSpent}
\title{Error spending functions}
\usage{
errorSpent(t, error, sf = "sfOF", sfpar = NA_real_)
}
\arguments{
\item{t}{Information fraction for the interim look.}

\item{error}{Total error to spend.}

\item{sf}{Spending function. One of the following: "sfOF" for
O'Brien-Fleming type spending function, "sfP" for Pocock type spending
function, "sfKD" for Kim & DeMets spending function, and "sfHSD" for
Hwang, Shi & DeCani spending function. Defaults to "sfOF".}

\item{sfpar}{Parameter for the spending function. Corresponds to rho for
"sfKD" and gamma for "sfHSD"}
}
\value{
A number for the error spent up to the interim look.
}
\description{
Obtains the error spent at the given information fraction
for the specified error spending function.
}
\examples{
errorSpent(t = 0.5, error = 0.025, sf = "sfOF")
errorSpent(t = 0.5, error = 0.025, sf = "sfHSD", sfpar = -4)

}
\keyword{internal}
