% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_headersize.R
\name{get_headersize}
\alias{get_headersize}
\title{Determine the size of an LPJmL input/output file header}
\usage{
get_headersize(header)
}
\arguments{
\item{header}{Header list object as returned by \code{\link[=read_header]{read_header()}} or
\code{\link[=create_header]{create_header()}}.}
}
\value{
Integer value giving the size of the header in bytes. This can be
used when seeking in the file or to calculate the expected total file size
in combination with the number of included data values and the data type.
}
\description{
Returns the size in bytes of an LPJmL file header based on a
header list object read by \code{\link[=read_header]{read_header()}} or generated by
\code{\link[=create_header]{create_header()}}.
}
\examples{
\dontrun{
header <- read_header("filename.clm")
size <- get_headersize(header)
# Open file for reading
fp <- file("filename.clm", "rb")
# Skip over file header
seek(fp, size)
# Add code to read data from file
}
}
\seealso{
\itemize{
\item \code{\link[=read_header]{read_header()}} for reading a header from an LPJmL input/output file.
\item \code{\link[=create_header]{create_header()}} for creating a header from scratch.
}
}
