% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPJmLData_as.R
\name{as_array}
\alias{as_array}
\title{Coerce an LPJmLData object to an array}
\usage{
as_array(x, subset = NULL, aggregate = NULL, ...)
}
\arguments{
\item{x}{\link{LPJmLData} object.}

\item{subset}{List of array dimension(s) as name/key and
corresponding subset vector as value, e.g.
\verb{list(cell = c(27411:27415)}. More information at
\code{\link[=subset.LPJmLData]{subset.LPJmLData()}}.}

\item{aggregate}{List of array dimension(s) as name/key and
corresponding aggregation function as value, e.g.
\code{list(band = sum)}.}

\item{...}{Arguments passed to the aggregate function(s), e.g.
\code{na.rm = TRUE}.}
}
\value{
an \link[base]{array} with dimensions of object \verb{$data} with
applied \code{subset} and \code{aggregate} functionality as well as \code{dim} and
\code{dimnames} from the \code{\link{LPJmLData}} object.
}
\description{
Function to coerce (convert) an \code{\link{LPJmLData}} object into a pure
\link[base]{array}. Pure - because LPJmLData stores the data already as
an \code{array} which can be accessed via \verb{$data}.
\code{as_array} provides additional functionality to subset or aggregate the
\code{array}.
}
\examples{
\dontrun{

vegc <- read_io(filename = "./vegc.bin.json")

# Returns array attribute of LPJmLData object directly
vegc$data
#        time
# cell      1901-12-31   1902-12-31   1903-12-31   1904-12-31   1905-12-31
#   0     1.362730e+04 1.363163e+04 1.364153e+04 1.365467e+04 1.366689e+04
#   1     1.201350e+02 1.158988e+02 1.101675e+02 1.214204e+02 1.062658e+02
#   2     1.334261e+02 1.210387e+02 1.218128e+02 1.183210e+02 1.159934e+02
#   3     9.744530e+01 9.586801e+01 8.365642e+01 8.193731e+01 7.757602e+01
#   4     7.592700e+01 7.821202e+01 6.798551e+01 6.632317e+01 5.691082e+01
#   5     1.106748e+01 1.137272e+01 1.196524e+01 1.131316e+01 9.924266e+0

# Returns two-dimensional array with timeseries for the mean across cells
# 27410:27415
as_array(vegc,
         subset = list(cell = 27410:27415),
         aggregate = list(cell = mean))

#             band
# time                1
#   1901-12-31 1995.959
#   1902-12-31 1979.585
#   1903-12-31 1978.054
#   1904-12-31 1935.623
#   1905-12-31 1938.805

}

}
