% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_lphom.R
\name{error_lphom}
\alias{error_lphom}
\title{Global error of a lphom estimated table}
\usage{
error_lphom(
  lphom.object,
  upper.alfa = 0.1,
  show.plot = TRUE,
  num.d = 11,
  B = 30
)
}
\arguments{
\item{lphom.object}{An object output of the \strong{lphom()} function.}

\item{upper.alfa}{Upper bound that will not be exceed by the EI estimate with a confidence 1 - alpha. By default, 0.10.}

\item{show.plot}{TRUE/FALSE. Indicates whether the plot showing the relationship between EI and HETe estimated by simulation for the election under study should be displayed as a side-effect. By default, TRUE.}

\item{num.d}{Number maximum of different disturbances, \code{d}, to be initially considered. Positive integer greater than or equal to 5. By default, 11.}

\item{B}{Integer that determines the number of simulations to be performed for each disturbance value. By default, 30.}
}
\value{
A list with the following components
\item{EI.estimate}{ Point estimate for EI.}
\item{EI.upper}{ Upper bound with confidence 1 - alpha of the EI estimate }
\item{figure}{ ggplot2 object describing the graphical representation of the relationship between EI and HETe.}
\item{equation}{ lm object of the adjustment between EI and HETe.}
\item{statistics}{ A four column matrix with the values of HET, HETe, EI and d associated with each simulated scenario.}
\item{TMs.real}{ Array with the simulated real transfer matrices associated with each scenario.}
\item{TMs.estimate}{ Array with the estimated transfer matrices associated with each scenario.}
}
\description{
Estimation of the error index (EI) of a RxC vote transfer matrix obtained with \strong{lphom()}
}
\note{
ggplot2 is needed to be installed for this function to work.

See equation (12) in Romero et al. (2020) for a definition of the EI index.
}
\examples{
mt.lphom <- lphom(France2017P[, 1:8], France2017P[, 9:12], "raw", NULL, FALSE)
set.seed(253443)
example <- error_lphom(mt.lphom, upper.alfa = 0.10, show.plot = FALSE, num.d = 5, B = 8)
example$EI.estimate
}
\references{
Romero, R, Pavia, JM, Martin, J and Romero G (2020). Assessing uncertainty of voter transitions estimated from aggregated data. Application to the 2017 French presidential election. \emph{Journal of Applied Statistics}, 47(13-15), 2711-2736. \doi{10.1080/02664763.2020.1804842}
}
\seealso{
\code{\link{lphom}} \code{\link{confidence_intervals_pjk}}
}
\author{
Jose M. Pavia, \email{pavia@uv.es}

Rafael Romero \email{rromero@eio.upv.es}
}
