% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qut.R
\name{qut}
\alias{qut}
\title{Automatic selection of nuclear norm regularization parameter}
\usage{
qut(Y, cov, lambda2 = 0, q = 0.95, N = 100, reff = T, ceff = T)
}
\arguments{
\item{Y}{A matrix of counts (contingency table).}

\item{cov}{A (np)xK matrix of K covariates about rows and columns}

\item{lambda2}{A positive number, the regularization parameter for covariates main effects}

\item{q}{A number between \code{0} and \code{1}. The quantile of the distribution of $lambda_{QUT}$ to take.}

\item{N}{An integer. The number of parametric bootstrap samples to draw.}

\item{reff}{[boolean] whether row effects should be fitted, default value is TRUE}

\item{ceff}{[boolean] whether column effects should be fitted, default value is TRUE}
}
\value{
the value of $lambda_{QUT}$ to use in LoRI.
}
\description{
Automatic selection of nuclear norm regularization parameter
}
\examples{
X = matrix(rnorm(30), 15)
Y = matrix(rpois(15, 1:15), 5)
lambda = qut(Y,X, 10, N=10)
}
