% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_regularization.R
\name{lambda_cv}
\alias{lambda_cv}
\title{Selects the parameter $lambda_{CV}$ with cross-validation.}
\usage{
lambda_cv(Y, cov = FALSE, projection = default_projection,
  gamma_init = NULL, X_init = NULL, Theta_init = NULL, tau = 0.1,
  epsilon = 1e-06, tol = 1e-12, max_it = 5 * 1e+05, upper = -log(1e-06),
  lower = log(1e-06), K = 10)
}
\arguments{
\item{Y}{A matrix of counts (contingency table).}

\item{cov}{A boolean \code{TRUE} if covariate matrices are provided, \code{FALSE} otherwise. Default is \code{FALSE}.}

\item{projection}{A projection function on the space orthogonal to covariates. By default centers by rows and columns}

\item{gamma_init}{A matrix. Initial dual variable, same size as X_init.}

\item{X_init}{A matrix. Initial Poisson parameter matrix, same size as Y.}

\item{Theta_init}{A matrix. Initial interaction matrix, same size as X_init.}

\item{tau}{A number (augmented Lagrangian parameter).}

\item{epsilon}{A number. Convergence tolerance of ADMM, by default \code{1e-6}.}

\item{tol}{A number. Convergence tolerance of gradient descent in ADMM iteration in \code{X}. By default\code{1e-12}.}

\item{max_it}{An integer. Maximum allowed number of iterations.}

\item{upper}{upper bound on the values of \code{X}.}

\item{lower}{lower bound on the values of \code{X}.}

\item{K}{An integer. The number of folds of the cross-validation.}
}
\value{
the value of $lambda_{CV}$ to use in LoRI.
}
\description{
Selects the parameter $lambda_{CV}$ with cross-validation.
}
\examples{
{
\dontshow{
X = matrix(rnorm(rep(0, 15)), 5)
Y = matrix(rpois(length(c(X)), exp(c(X))), 5)
lambda = lambda_cv(Y, K = 2, max_it = 2)
}
}
}
