% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balanced_data.R
\name{balanced.train.and.test}
\alias{balanced.train.and.test}
\title{Get a balanced test and train dataset}
\usage{
balanced.train.and.test(..., train.perc = 0.9, join.all = TRUE)
}
\arguments{
\item{...}{vectors of index (could be numeric or logical)}

\item{train.perc}{percentage of dataset to be training set}

\item{join.all}{join all index in the end in two vectors (train and
test vectors)}
}
\value{
train and test index vectors (two lists if `join.all = FALSE`,
two vectors otherwise)
}
\description{
Get a balanced test and train dataset
}
\examples{
set1 <- seq(20)
balanced.train.and.test(set1, train.perc = .9)
####
set.seed(1985)
set1 <- rbinom(20, prob = 3/20, size = 1) == 1
balanced.train.and.test(set1, train.perc = .9)
####
set1 <- c(TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,FALSE,
TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,FALSE,TRUE)
set2 <- !set1
balanced.train.and.test(set1, set2, train.perc = .9)
}
