% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphutils.R
\name{loongraph}
\alias{loongraph}
\title{Create a graph object of class loongraph}
\usage{
loongraph(nodes, from = character(0), to = character(0),
  isDirected = FALSE)
}
\arguments{
\item{nodes}{a character vector with node names, each element defines a node
hence the elements need to be unique}

\item{from}{a character vector with node names, each element defines an edge}

\item{to}{a character vector with node names, each element defines an edge}

\item{isDirected}{boolean scalar, defines whether from and to define directed
edges}
}
\value{
graph object of class loongraph
}
\description{
The loongraph class provides a simple alternative to the graph 
  class to create common graphs that are useful for use as navigation graphs.
}
\details{
loongraph objects can be converted to graph objects (i.e. objects of
class graph which is defined in the graph package) with the as.graph 
function.

For more information run: \code{l_help("learn_R_display_graph.html.html#graph-utilities")}
}
\examples{
g <- loongraph(
  nodes = c("A", "B", "C", "D"),
  from = c("A", "A", "B", "B", "C"),
  to   = c("B", "C", "C", "D", "D")
)

\dontrun{
# create a loon graph plot
p <- l_graph(g)
}

lg <- linegraph(g)
}
\seealso{
\code{\link{completegraph}}, \code{\link{linegraph}}, 
  \code{\link{complement}}, \code{\link{as.graph}}
}
