% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_demote}
\alias{l_layer_demote}
\title{Moves the layer to be a child of its right group layer sibling}
\usage{
l_layer_demote(widget, layer)
}
\arguments{
\item{widget}{widget path or layer object of class \code{'l_layer'}}

\item{layer}{layer id. If the widget argument is of class \code{'l_layer'}
then the layer argument is not used}
}
\value{
0 if success otherwise the function throws an error
}
\description{
Moves the layer up the layer tree (away from the root layer) if
  there is a sibling group layer to the right of the layer.
}
\examples{
p <- l_plot()

g1 <- l_layer_group(p)
g2 <- l_layer_group(p, parent=g1)
l1 <- l_layer_oval(p, x=0:1, y=0:1)

l_layer_printTree(p) 
l_layer_demote(p, l1)
l_layer_printTree(p)
l_layer_demote(p, l1)
l_layer_printTree(p)
}
