% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loonGrob_l_ggplot.R
\name{l_getSubtitles}
\alias{l_getSubtitles}
\title{Return the subtitles from an \code{l_facet_ggplot} object}
\usage{
l_getSubtitles(target)
}
\arguments{
\item{target}{an \code{l_facet_ggplot} object. If the ggplot object is
faceted (either by \code{facet_wrap} or \code{facet_grid}),
an \code{l_facet_ggplot} object will be returned once it is turned
to a \code{loon} plot.}
}
\value{
A list of labels, i.e. subtitles, labels, title, etc
}
\description{
Return the subtitles from an \code{l_facet_ggplot} object
}
\examples{
if(interactive()) {
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  facet_wrap(vars(class))
lp <- loon.ggplot(p)
l_getSubtitles(lp)
}
}
