% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_ggplot.R
\name{l_ggplot}
\alias{l_ggplot}
\title{Automatically create a loon widget}
\usage{
l_ggplot(data = NULL, mapping = aes(), ..., environment = parent.frame())
}
\arguments{
\item{data}{Default dataset to use for plot. If not already a data.frame, will be converted to one by fortify().
If not specified, must be supplied in each layer added to the plot.}

\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}

\item{...}{Other arguments passed on to methods. Not currently used.}

\item{environment}{DEPRECATED. Used prior to tidy evaluation.}
}
\value{
It will return a \code{lggplot} object with class \code{c("lggplot", "gg", "ggplot")}.
Then print a \code{loon} plot automatically.
}
\description{
\code{l_ggplot()} wraps function \code{ggplot} with assigning a new class "lggplot" to the output
\code{ggplot} object and returns a \code{lggplot} object. When a \code{ggplot} object is processed,
S3 method \code{print.ggplot} is rendered, however, if a \code{lggplot} object is processed,
S3 method \code{print.lggplot} will be rendered which will return a \code{loon} widget
}
\examples{
if(interactive()) {
p <- l_ggplot(mpg, aes(displ, cty)) +
    geom_point(
      size = 4,
      mapping = aes(color = factor(cyl))
    )
# p is a `lggplot` object, `print.lggplot(p)` will be called automatically.
# Then, a `lggplot` object will be transformed to a `loon` widget
p

\dontrun{
# Assign a widget from current path
# suppose the path of `p` is '.l0.ggplot'
q <- l_getFromPath('.l0.ggplot')
# q is a `loon` widget
q
}

# An alternative way to return a real loon widget from `p` (a `lggplot` object)
# is to call the function `loon.ggplot`. Compared with calling function `l_getFrompath`
# this way can provide richer information (note that it will create a new widget).
q <- loon.ggplot(p)
q

# pipe more components
p +
  facet_grid(rows = vars(drv)) +
  linking(linkingGroup = "mpg") +
  ggtitle("displ versus cty")
# a linked bar plot
l_hist(mpg$class, linkingGroup = "mpg")

# a 3D object
# press the button key `R` to rotate the plot
l_ggplot(mtcars,
         mapping = aes(x = wt, y = hp, z = drat)) +
   geom_point(size = 4)
}
}
\seealso{
\code{\link{ggplot}}, \code{\link{ggplot2loon}}, \code{\link{print.lggplot}}

\code{\link{loon.ggplot}}
}
