% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo_moment_matching.R
\name{loo_moment_match}
\alias{loo_moment_match}
\alias{loo_moment_match.default}
\title{Moment matching for efficient approximate leave-one-out cross-validation (LOO)}
\usage{
loo_moment_match(x, ...)

\method{loo_moment_match}{default}(
  x,
  loo,
  post_draws,
  log_lik_i,
  unconstrain_pars,
  log_prob_upars,
  log_lik_i_upars,
  max_iters = 30L,
  k_threshold = 0.7,
  split = TRUE,
  cov = TRUE,
  cores = getOption("mc.cores", 1),
  ...
)
}
\arguments{
\item{x}{A fitted model object.}

\item{...}{Further arguments passed to the custom functions documented above.}

\item{loo}{A loo object to be modified.}

\item{post_draws}{A function the takes \code{x} as the first argument and returns
a matrix of posterior draws of the model parameters.}

\item{log_lik_i}{A function that takes \code{x} and \code{i} and returns a matrix (one
column per chain) or a vector (all chains stacked) of log-likelihood draws
of the \code{i}th observation based on the model \code{x}. If the draws are obtained
using MCMC, the matrix with MCMC chains separated is preferred.}

\item{unconstrain_pars}{A function that takes arguments \code{x}, and \code{pars} and
returns posterior draws on the unconstrained space based on the posterior
draws on the constrained space passed via \code{pars}.}

\item{log_prob_upars}{A function that takes arguments \code{x} and \code{upars} and
returns a matrix of log-posterior density values of the unconstrained
posterior draws passed via \code{upars}.}

\item{log_lik_i_upars}{A function that takes arguments \code{x}, \code{upars}, and \code{i}
and returns a vector of log-likelihood draws of the \code{i}th observation based
on the unconstrained posterior draws passed via \code{upars}.}

\item{max_iters}{Maximum number of moment matching iterations. Usually this
does not need to be modified. If the maximum number of iterations is
reached, there will be a warning, and increasing \code{max_iters} may improve
accuracy.}

\item{k_threshold}{Threshold value for Pareto k values above which the moment
matching algorithm is used. The default value is 0.5.}

\item{split}{Logical; Indicate whether to do the split transformation or not
at the end of moment matching for each LOO fold.}

\item{cov}{Logical; Indicate whether to match the covariance matrix of the
samples or not. If \code{FALSE}, only the mean and marginal variances are
matched.}

\item{cores}{The number of cores to use for parallelization. This defaults to
the option \code{mc.cores} which can be set for an entire R session by
\code{options(mc.cores = NUMBER)}. The old option \code{loo.cores} is now
deprecated but will be given precedence over \code{mc.cores} until
\code{loo.cores} is removed in a future release. \strong{As of version
2.0.0 the default is now 1 core if \code{mc.cores} is not set}, but we
recommend using as many (or close to as many) cores as possible.
\itemize{
\item Note for Windows 10 users: it is \strong{strongly}
\href{https://github.com/stan-dev/loo/issues/94}{recommended} to avoid using
the \code{.Rprofile} file to set \code{mc.cores} (using the \code{cores} argument or
setting \code{mc.cores} interactively or in a script is fine).
}}
}
\value{
The \code{loo_moment_match()} methods return an updated \code{loo} object. The
structure of the updated \code{loo} object is similar, but the method also
stores the original Pareto k diagnostic values in the diagnostics field.
}
\description{
Moment matching algorithm for updating a loo object when Pareto k estimates
are large.
}
\details{
The \code{loo_moment_match()} function is an S3 generic and we provide a
default method that takes as arguments user-specified functions
\code{post_draws}, \code{log_lik_i}, \code{unconstrain_pars}, \code{log_prob_upars}, and
\code{log_lik_i_upars}. All of these functions should take \code{...}. as an argument
in addition to those specified for each function.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: A default method that takes as arguments a
user-specified model object \code{x}, a \code{loo} object and user-specified
functions \code{post_draws}, \code{log_lik_i}, \code{unconstrain_pars}, \code{log_prob_upars},
and \code{log_lik_i_upars}.
}}

\examples{
# See the vignette for loo_moment_match()
}
\references{
Paananen, T., Piironen, J., Buerkner, P.-C., Vehtari, A. (2020).
Implicitly Adaptive Importance Sampling.
\href{https://arxiv.org/abs/1906.08850/}{preprint arXiv:1906.08850}
}
\seealso{
\code{\link[=loo]{loo()}}, \code{\link[=loo_moment_match_split]{loo_moment_match_split()}}
}
