% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centroid.R
\name{predict.nearestCentroid}
\alias{predict.nearestCentroid}
\title{Nearest Centroid Classifier Prediction}
\usage{
\method{predict}{nearestCentroid}(object, X, ...)
}
\arguments{
\item{object}{An object of class \code{nearestCentroid}, with the following attributes:
\itemize{
\item{centroids}{\code{[K, d]} the centroids of each class with \code{K} classes in \code{d} dimensions.}
\item{ylabs}{\code{[K]} the ylabels for each of the \code{K} unique classes, ordered.}
\item{priors}{\code{[K]} the priors for each of the \code{K} classes.}
}}

\item{X}{\code{[n, d]} the data to classify with \code{n} samples in \code{d} dimensions.}

\item{...}{optional args.}
}
\value{
Yhat \code{[n]} the predicted class of each of the \code{n} data point in \code{X}.
}
\description{
A function that predicts the class of points based on the nearest centroid
}
\examples{
library(lolR)
data <- lol.sims.rtrunk(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
model <- lol.classify.nearestCentroid(X, Y)
Yh <- predict(model, X)
}
\author{
Eric Bridgeford
}
