% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.flic.R
\name{predict.flic}
\alias{predict.flic}
\title{Predict Method for flic Fits}
\usage{
\method{predict}{flic}(
  object,
  newdata,
  type = c("link", "response", "terms"),
  se.fit = FALSE,
  ...
)
}
\arguments{
\item{object}{A fitted object of class \code{flic}.}

\item{newdata}{Optionally, a data frame in which to look for variables with which to predict. If omitted, the fitted linear predictors are used.}

\item{type}{The type of prediction required. The default is on the scale of the linear predictors.
The alternative \code{response} gives the predicted probabilities. Type \code{terms} returns a matrix with the fitted
values of each term in the formula on the linear predictor scale.}

\item{se.fit}{If \code{TRUE}(default = \code{FALSE}) standard errors are computed.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A vector or matrix of predictions
}
\description{
Obtains predictions from a fitted \code{flic} object.
}
\details{
If \code{newdata} is omitted the predictions are based on the data used for the fit.
}
